# Frontend part - End to End Tests

## Project setup
```
npm install
```

## Run tests

The frontend app needs to be running for the tests.

Start Cypress GUI:
```
npm run cypress -- open
```

Run integration tests in background/headless mode:
```
npm run cypress -- run
```

## Configuration

You can overwrite any configuration by passing an environment variable to cypress.

Specify the host URL:
```
npm run cypress -- run --env URL=https://localhost
```

Available environment variables and their defaults:
```bash
URL=http://localhost:4200
```

## Test specification files
```
<tests/frontend-gui-js/>cypress/support/commands.ts
<tests/frontend-gui-js/>cypress/integration/*_spec.ts
```
